#ifndef ODEWHEELCYLINDER_H_
#define ODEWHEELCYLINDER_H_

#include "IPhysicalWheelCylinder.h"

#include <ode/ode.h>
namespace PhysicsEngine
{

class ODEWheelCylinder : public PhysicsEngine::IPhysicalWheelCylinder
{
public:
	ODEWheelCylinder();
	ODEWheelCylinder(dWorldID world, int objectid, float radius, float length, Vector3f position,Vector3f rotation, int materialid, float mass, Vector3f linearvelocity, Vector3f angularvelocity);
	virtual ~ODEWheelCylinder();
	void UpdateData();
	dGeomID GetGeomId();
	DataWheelCylinder *GetDataWheelCylinder();
	dWorldID GetWorldId();
	void SetWorldId(dWorldID world);
	void RotateObject(float axis_x, float axis_y, float axis_z, float angle);
	void SetPhysicalPosition(float posx, float posy, float posz);
	Vector3f GetAngularVelocity();
	Vector3f GetLinearVelocity();
private:
	dGeomID bodyid;
	dWorldID world;	
};

}

#endif /*ODEWHEELCYLINDER_H_*/
